/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common;

import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.client.StorageCellModels;
import appeng.api.features.GridLinkables;
import appeng.api.features.HotkeyAction;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.inventories.PartApiLookup;
import appeng.api.parts.PartModels;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.block.AEBaseBlockItem;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.ClientTickingBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.hotkeys.HotkeyActions;
import appeng.hotkeys.InventoryHotkeyAction;
import appeng.items.AEBaseItem;
import appeng.items.tools.powered.WirelessTerminalItem;
import com.github.glodblock.extendedae.EAE;
import com.github.glodblock.extendedae.common.EAEItemAndBlock;
import com.github.glodblock.extendedae.common.inventory.InfinityCellInventory;
import com.github.glodblock.extendedae.common.items.ItemMEPackingTape;
import com.github.glodblock.extendedae.common.parts.PartActiveFormationPlane;
import com.github.glodblock.extendedae.common.parts.PartExExportBus;
import com.github.glodblock.extendedae.common.parts.PartExImportBus;
import com.github.glodblock.extendedae.common.parts.PartExInterface;
import com.github.glodblock.extendedae.common.parts.PartExPatternAccessTerminal;
import com.github.glodblock.extendedae.common.parts.PartExPatternProvider;
import com.github.glodblock.extendedae.common.parts.PartModExportBus;
import com.github.glodblock.extendedae.common.parts.PartModStorageBus;
import com.github.glodblock.extendedae.common.parts.PartPreciseExportBus;
import com.github.glodblock.extendedae.common.parts.PartPreciseStorageBus;
import com.github.glodblock.extendedae.common.parts.PartTagExportBus;
import com.github.glodblock.extendedae.common.parts.PartTagStorageBus;
import com.github.glodblock.extendedae.common.parts.PartThresholdExportBus;
import com.github.glodblock.extendedae.common.parts.PartThresholdLevelEmitter;
import com.github.glodblock.extendedae.common.tileentities.TileCaner;
import com.github.glodblock.extendedae.common.tileentities.TileExCharger;
import com.github.glodblock.extendedae.common.tileentities.TileExInscriber;
import com.github.glodblock.extendedae.common.tileentities.TileExInterface;
import com.github.glodblock.extendedae.common.tileentities.TileExMolecularAssembler;
import com.github.glodblock.extendedae.common.tileentities.TileExPatternProvider;
import com.github.glodblock.extendedae.common.tileentities.TileIngredientBuffer;
import com.github.glodblock.extendedae.config.EPPConfig;
import com.github.glodblock.extendedae.container.ContainerActiveFormationPlane;
import com.github.glodblock.extendedae.container.ContainerCaner;
import com.github.glodblock.extendedae.container.ContainerExDrive;
import com.github.glodblock.extendedae.container.ContainerExIOBus;
import com.github.glodblock.extendedae.container.ContainerExIOPort;
import com.github.glodblock.extendedae.container.ContainerExInscriber;
import com.github.glodblock.extendedae.container.ContainerExInterface;
import com.github.glodblock.extendedae.container.ContainerExMolecularAssembler;
import com.github.glodblock.extendedae.container.ContainerExPatternProvider;
import com.github.glodblock.extendedae.container.ContainerExPatternTerminal;
import com.github.glodblock.extendedae.container.ContainerIngredientBuffer;
import com.github.glodblock.extendedae.container.ContainerModExportBus;
import com.github.glodblock.extendedae.container.ContainerModStorageBus;
import com.github.glodblock.extendedae.container.ContainerPatternModifier;
import com.github.glodblock.extendedae.container.ContainerPreciseExportBus;
import com.github.glodblock.extendedae.container.ContainerPreciseStorageBus;
import com.github.glodblock.extendedae.container.ContainerRenamer;
import com.github.glodblock.extendedae.container.ContainerTagExportBus;
import com.github.glodblock.extendedae.container.ContainerTagStorageBus;
import com.github.glodblock.extendedae.container.ContainerThresholdExportBus;
import com.github.glodblock.extendedae.container.ContainerThresholdLevelEmitter;
import com.github.glodblock.extendedae.container.ContainerWirelessConnector;
import com.github.glodblock.extendedae.container.ContainerWirelessExPAT;
import com.github.glodblock.extendedae.container.pattern.ContainerCraftingPattern;
import com.github.glodblock.extendedae.container.pattern.ContainerProcessingPattern;
import com.github.glodblock.extendedae.container.pattern.ContainerSmithingTablePattern;
import com.github.glodblock.extendedae.container.pattern.ContainerStonecuttingPattern;
import com.github.glodblock.extendedae.util.FCUtil;
import com.github.glodblock.extendedae.xmod.wt.WTCommonLoad;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_5558;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;

public class RegistryHandler {
    public static final RegistryHandler INSTANCE = new RegistryHandler();
    protected final List<Pair<String, class_2248>> blocks = new ArrayList<Pair<String, class_2248>>();
    protected final List<Pair<String, class_1792>> items = new ArrayList<Pair<String, class_1792>>();
    protected final List<Pair<String, class_2591<?>>> tiles = new ArrayList();

    public void block(String name, class_2248 block) {
        this.blocks.add((Pair<String, class_2248>)Pair.of((Object)name, (Object)block));
        if (block instanceof AEBaseEntityBlock) {
            AEBaseEntityBlock tileBlock = (AEBaseEntityBlock)block;
            this.tile(name, tileBlock.getBlockEntityType());
        }
    }

    public <T extends AEBaseBlockEntity> void block(String name, AEBaseEntityBlock<T> block, Class<T> clazz, class_2591.class_5559<? extends T> supplier) {
        this.bindTileEntity(clazz, block, supplier);
        this.block(name, (class_2248)block);
    }

    public void item(String name, class_1792 item) {
        this.items.add((Pair<String, class_1792>)Pair.of((Object)name, (Object)item));
    }

    public void tile(String name, class_2591<?> type) {
        this.tiles.add(Pair.of((Object)name, type));
    }

    public void runRegister() {
        this.onRegisterBlocks();
        this.onRegisterItems();
        this.onRegisterTileEntities();
        this.onRegisterContainer();
        this.onRegisterModels();
        this.onRegisterRandomAPI();
        if (EAE.checkMod("ae2wtlib")) {
            WTCommonLoad.init();
        }
    }

    private void onRegisterBlocks() {
        for (Pair<String, class_2248> entry : this.blocks) {
            String key = (String)entry.getLeft();
            class_2248 block = (class_2248)entry.getRight();
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)EAE.id(key), (Object)block);
        }
    }

    private void onRegisterItems() {
        for (Pair<String, class_2248> pair : this.blocks) {
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)EAE.id((String)pair.getLeft()), (Object)new AEBaseBlockItem((class_2248)pair.getRight(), new class_1792.class_1793()));
        }
        for (Pair<String, class_2248> pair : this.items) {
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)EAE.id((String)pair.getLeft()), (Object)((class_1792)pair.getRight()));
        }
    }

    private void onRegisterTileEntities() {
        for (Pair<String, class_2591<?>> entry : this.tiles) {
            String key = (String)entry.getLeft();
            class_2591 tile = (class_2591)entry.getRight();
            class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)EAE.id(key), (Object)tile);
        }
    }

    private void onRegisterContainer() {
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)ContainerProcessingPattern.ID, ContainerProcessingPattern.TYPE);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)ContainerCraftingPattern.ID, ContainerCraftingPattern.TYPE);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)ContainerStonecuttingPattern.ID, ContainerStonecuttingPattern.TYPE);
        class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)ContainerSmithingTablePattern.ID, ContainerSmithingTablePattern.TYPE);
        this.registerMenuType("ex_pattern_provider", ContainerExPatternProvider.TYPE);
        this.registerMenuType("ex_interface", ContainerExInterface.TYPE);
        this.registerMenuType("ex_export_bus", ContainerExIOBus.EXPORT_TYPE);
        this.registerMenuType("ex_import_bus", ContainerExIOBus.IMPORT_TYPE);
        this.registerMenuType("ex_pattern_access_terminal", ContainerExPatternTerminal.TYPE);
        this.registerMenuType("wireless_connector", ContainerWirelessConnector.TYPE);
        this.registerMenuType("ingredient_buffer", ContainerIngredientBuffer.TYPE);
        this.registerMenuType("ex_drive", ContainerExDrive.TYPE);
        this.registerMenuType("pattern_modifier", ContainerPatternModifier.TYPE);
        this.registerMenuType("ex_molecular_assembler", ContainerExMolecularAssembler.TYPE);
        this.registerMenuType("ex_inscriber", ContainerExInscriber.TYPE);
        this.registerMenuType("tag_storage_bus", ContainerTagStorageBus.TYPE);
        this.registerMenuType("tag_export_bus", ContainerTagExportBus.TYPE);
        this.registerMenuType("threshold_level_emitter", ContainerThresholdLevelEmitter.TYPE);
        this.registerMenuType("renamer", ContainerRenamer.TYPE);
        this.registerMenuType("mod_storage_bus", ContainerModStorageBus.TYPE);
        this.registerMenuType("mod_export_bus", ContainerModExportBus.TYPE);
        this.registerMenuType("active_formation_plane", ContainerActiveFormationPlane.TYPE);
        this.registerMenuType("caner", ContainerCaner.TYPE);
        this.registerMenuType("wireless_ex_pat", ContainerWirelessExPAT.TYPE);
        this.registerMenuType("ex_ioport", ContainerExIOPort.TYPE);
        this.registerMenuType("precise_export_bus", ContainerPreciseExportBus.TYPE);
        this.registerMenuType("precise_storage_bus", ContainerPreciseStorageBus.TYPE);
        this.registerMenuType("threshold_export_bus", ContainerThresholdExportBus.TYPE);
        if (EAE.checkMod("ae2wtlib")) {
            WTCommonLoad.container();
        }
    }

    private void registerMenuType(String id, class_3917<?> menuType) {
        if (!class_7923.field_41187.method_10250(AppEng.makeId((String)id))) {
            class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)AppEng.makeId((String)id), menuType);
        }
    }

    private <T extends AEBaseBlockEntity> void bindTileEntity(Class<T> clazz, AEBaseEntityBlock<T> block, class_2591.class_5559<? extends T> supplier) {
        class_5558 serverTicker = null;
        if (ServerTickingBlockEntity.class.isAssignableFrom(clazz)) {
            serverTicker = (level, pos, state, entity) -> ((ServerTickingBlockEntity)entity).serverTick();
        }
        class_5558 clientTicker = null;
        if (ClientTickingBlockEntity.class.isAssignableFrom(clazz)) {
            clientTicker = (level, pos, state, entity) -> ((ClientTickingBlockEntity)entity).clientTick();
        }
        block.setBlockEntity(clazz, FCUtil.getTileType(clazz, supplier, block), clientTicker, serverTicker);
    }

    public void onInit() {
        for (Pair<String, class_2248> entry : this.blocks) {
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(EAE.id((String)entry.getKey()));
            if (!(block instanceof AEBaseEntityBlock)) continue;
            AEBaseBlockEntity.registerBlockEntityItem((class_2591)((AEBaseEntityBlock)block).getBlockEntityType(), (class_1792)block.method_8389());
        }
        this.registerStorageHandler();
        this.registerCapabilities();
        this.registerUpgrade();
        this.initPackageList();
        this.bindItemTab();
    }

    private void registerUpgrade() {
        Upgrades.add((class_1935)AEItems.FUZZY_CARD, (class_1935)EAEItemAndBlock.EX_INTERFACE.method_8389(), (int)1, (String)"gui.extendedae.ex_interface");
        Upgrades.add((class_1935)AEItems.CRAFTING_CARD, (class_1935)EAEItemAndBlock.EX_INTERFACE.method_8389(), (int)1, (String)"gui.extendedae.ex_interface");
        Upgrades.add((class_1935)AEItems.FUZZY_CARD, (class_1935)EAEItemAndBlock.EX_INTERFACE_PART.method_8389(), (int)1, (String)"gui.extendedae.ex_interface");
        Upgrades.add((class_1935)AEItems.CRAFTING_CARD, (class_1935)EAEItemAndBlock.EX_INTERFACE_PART.method_8389(), (int)1, (String)"gui.extendedae.ex_interface");
        Upgrades.add((class_1935)AEItems.CAPACITY_CARD, EAEItemAndBlock.EX_EXPORT_BUS, (int)5, (String)"group.ex_io_bus_part");
        Upgrades.add((class_1935)AEItems.REDSTONE_CARD, EAEItemAndBlock.EX_EXPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((class_1935)AEItems.SPEED_CARD, EAEItemAndBlock.EX_EXPORT_BUS, (int)4, (String)"group.ex_io_bus_part");
        Upgrades.add((class_1935)AEItems.INVERTER_CARD, EAEItemAndBlock.EX_EXPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((class_1935)AEItems.FUZZY_CARD, EAEItemAndBlock.EX_EXPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((class_1935)AEItems.CRAFTING_CARD, EAEItemAndBlock.EX_EXPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((class_1935)AEItems.CAPACITY_CARD, EAEItemAndBlock.EX_IMPORT_BUS, (int)5, (String)"group.ex_io_bus_part");
        Upgrades.add((class_1935)AEItems.REDSTONE_CARD, EAEItemAndBlock.EX_IMPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((class_1935)AEItems.SPEED_CARD, EAEItemAndBlock.EX_IMPORT_BUS, (int)4, (String)"group.ex_io_bus_part");
        Upgrades.add((class_1935)AEItems.INVERTER_CARD, EAEItemAndBlock.EX_IMPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((class_1935)AEItems.FUZZY_CARD, EAEItemAndBlock.EX_IMPORT_BUS, (int)1, (String)"group.ex_io_bus_part");
        Upgrades.add((class_1935)AEItems.ENERGY_CARD, (class_1935)EAEItemAndBlock.WIRELESS_CONNECTOR, (int)4);
        Upgrades.add((class_1935)AEItems.SPEED_CARD, (class_1935)EAEItemAndBlock.EX_ASSEMBLER, (int)5);
        Upgrades.add((class_1935)AEItems.SPEED_CARD, (class_1935)EAEItemAndBlock.EX_INSCRIBER, (int)4);
        Upgrades.add((class_1935)AEItems.INVERTER_CARD, EAEItemAndBlock.TAG_STORAGE_BUS, (int)1);
        Upgrades.add((class_1935)AEItems.VOID_CARD, EAEItemAndBlock.TAG_STORAGE_BUS, (int)1);
        Upgrades.add((class_1935)AEItems.REDSTONE_CARD, EAEItemAndBlock.TAG_EXPORT_BUS, (int)1);
        Upgrades.add((class_1935)AEItems.SPEED_CARD, EAEItemAndBlock.TAG_EXPORT_BUS, (int)4);
        Upgrades.add((class_1935)AEItems.FUZZY_CARD, EAEItemAndBlock.THRESHOLD_LEVEL_EMITTER, (int)1);
        Upgrades.add((class_1935)AEItems.INVERTER_CARD, EAEItemAndBlock.MOD_STORAGE_BUS, (int)1);
        Upgrades.add((class_1935)AEItems.VOID_CARD, EAEItemAndBlock.MOD_STORAGE_BUS, (int)1);
        Upgrades.add((class_1935)AEItems.REDSTONE_CARD, EAEItemAndBlock.MOD_EXPORT_BUS, (int)1);
        Upgrades.add((class_1935)AEItems.SPEED_CARD, EAEItemAndBlock.MOD_EXPORT_BUS, (int)4);
        Upgrades.add((class_1935)AEItems.FUZZY_CARD, EAEItemAndBlock.ACTIVE_FORMATION_PLANE, (int)1);
        Upgrades.add((class_1935)AEItems.CAPACITY_CARD, EAEItemAndBlock.ACTIVE_FORMATION_PLANE, (int)5);
        Upgrades.add((class_1935)AEItems.ENERGY_CARD, (class_1935)EAEItemAndBlock.WIRELESS_EX_PAT, (int)2, (String)GuiText.WirelessTerminals.getTranslationKey());
        Upgrades.add((class_1935)AEItems.SPEED_CARD, (class_1935)EAEItemAndBlock.EX_IO_PORT, (int)5);
        Upgrades.add((class_1935)AEItems.REDSTONE_CARD, (class_1935)EAEItemAndBlock.EX_IO_PORT, (int)1);
        Upgrades.add((class_1935)AEItems.CAPACITY_CARD, EAEItemAndBlock.PRECISE_EXPORT_BUS, (int)5);
        Upgrades.add((class_1935)AEItems.REDSTONE_CARD, EAEItemAndBlock.PRECISE_EXPORT_BUS, (int)1);
        Upgrades.add((class_1935)AEItems.CRAFTING_CARD, EAEItemAndBlock.PRECISE_EXPORT_BUS, (int)1);
        Upgrades.add((class_1935)AEItems.CAPACITY_CARD, EAEItemAndBlock.PRECISE_STORAGE_BUS, (int)5);
        Upgrades.add((class_1935)AEItems.VOID_CARD, EAEItemAndBlock.PRECISE_STORAGE_BUS, (int)1);
        Upgrades.add((class_1935)AEItems.CAPACITY_CARD, EAEItemAndBlock.THRESHOLD_EXPORT_BUS, (int)5);
        Upgrades.add((class_1935)AEItems.REDSTONE_CARD, EAEItemAndBlock.THRESHOLD_EXPORT_BUS, (int)1);
        Upgrades.add((class_1935)AEItems.SPEED_CARD, EAEItemAndBlock.THRESHOLD_EXPORT_BUS, (int)4);
    }

    private void registerCapabilities() {
        PartApiLookup.register((BlockApiLookup)GenericInternalInventory.SIDED, (part, context) -> part.getInterfaceLogic().getStorage(), PartExInterface.class);
        PartApiLookup.register((BlockApiLookup)MEStorage.SIDED, (part, context) -> part.getInterfaceLogic().getInventory(), PartExInterface.class);
        PartApiLookup.register((BlockApiLookup)GenericInternalInventory.SIDED, (part, context) -> part.getLogic().getReturnInv(), PartExPatternProvider.class);
        ICrankable.LOOKUP.registerForBlockEntity(TileExCharger::getCrankable, FCUtil.getTileType(TileExCharger.class));
        ICrankable.LOOKUP.registerForBlockEntity(TileExInscriber::getCrankable, FCUtil.getTileType(TileExInscriber.class));
        GenericInternalInventory.SIDED.registerForBlockEntity((blockEntity, context) -> blockEntity.getInterfaceLogic().getStorage(), FCUtil.getTileType(TileExInterface.class));
        MEStorage.SIDED.registerForBlockEntity((blockEntity, context) -> blockEntity.getInterfaceLogic().getInventory(), FCUtil.getTileType(TileExInterface.class));
        ICraftingMachine.SIDED.registerSelf(new class_2591[]{FCUtil.getTileType(TileExMolecularAssembler.class)});
        GenericInternalInventory.SIDED.registerForBlockEntity((blockEntity, context) -> blockEntity.getLogic().getReturnInv(), FCUtil.getTileType(TileExPatternProvider.class));
        GenericInternalInventory.SIDED.registerForBlockEntity((blockEntity, context) -> blockEntity.getInventory(), FCUtil.getTileType(TileIngredientBuffer.class));
        ICraftingMachine.SIDED.registerForBlockEntity((blockEntity, context) -> blockEntity, FCUtil.getTileType(TileCaner.class));
        GenericInternalInventory.SIDED.registerForBlockEntity((blockEntity, context) -> blockEntity.getStuff(), FCUtil.getTileType(TileCaner.class));
    }

    private void registerStorageHandler() {
        StorageCells.addCellHandler((ICellHandler)InfinityCellInventory.HANDLER);
        StorageCellModels.registerModel((class_1935)EAEItemAndBlock.INFINITY_CELL, (class_2960)EAE.id("block/drive/infinity_cell"));
    }

    private void onRegisterModels() {
        PartModels.registerModels(PartExPatternProvider.MODELS);
        PartModels.registerModels(PartExInterface.MODELS);
        PartModels.registerModels(PartExExportBus.MODELS);
        PartModels.registerModels(PartExImportBus.MODELS);
        PartModels.registerModels(PartExPatternAccessTerminal.MODELS);
        PartModels.registerModels((class_2960[])new class_2960[]{PartTagStorageBus.MODEL_BASE});
        PartModels.registerModels((class_2960[])new class_2960[]{PartTagExportBus.MODEL_BASE});
        PartModels.registerModels(PartThresholdLevelEmitter.MODELS);
        PartModels.registerModels((class_2960[])new class_2960[]{PartModStorageBus.MODEL_BASE});
        PartModels.registerModels((class_2960[])new class_2960[]{PartModExportBus.MODEL_BASE});
        PartModels.registerModels(PartActiveFormationPlane.MODELS);
        PartModels.registerModels(PartPreciseExportBus.MODELS);
        PartModels.registerModels((class_2960[])new class_2960[]{PartPreciseStorageBus.MODEL_BASE});
        PartModels.registerModels(PartThresholdExportBus.MODELS);
    }

    private void onRegisterRandomAPI() {
        GridLinkables.register((class_1935)EAEItemAndBlock.WIRELESS_EX_PAT, (IGridLinkableHandler)WirelessTerminalItem.LINKABLE_HANDLER);
        if (!EAE.checkMod("ae2wtlib")) {
            HotkeyActions.register((HotkeyAction)new InventoryHotkeyAction((class_1792)EAEItemAndBlock.WIRELESS_EX_PAT, (player, i) -> EAEItemAndBlock.WIRELESS_EX_PAT.openFromInventory(player, i)), (String)"wireless_terminal");
        } else {
            HotkeyActions.register((HotkeyAction)new InventoryHotkeyAction((class_1792)EAEItemAndBlock.WIRELESS_EX_PAT, (player, i) -> EAEItemAndBlock.WIRELESS_EX_PAT.openFromInventory(player, i)), (String)"wireless_pattern_access_terminal");
        }
    }

    public Collection<class_2248> getBlocks() {
        return this.blocks.stream().map(Pair::getRight).toList();
    }

    private void bindItemTab() {
        class_1761 tab = FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)EAEItemAndBlock.EX_PATTERN_PROVIDER)).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.epp")).method_47317((__, o) -> {
            for (Pair<String, class_1792> pair : this.items) {
                Object patt20622$temp = pair.getRight();
                if (patt20622$temp instanceof AEBaseItem) {
                    AEBaseItem aeItem = (AEBaseItem)patt20622$temp;
                    aeItem.addToMainCreativeTab(o);
                    continue;
                }
                o.method_45421((class_1935)pair.getRight());
            }
            for (Pair<String, class_1792> pair : this.blocks) {
                o.method_45421((class_1935)pair.getRight());
            }
        }).method_47324();
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)EAE.id("tab_main"), (Object)tab);
    }

    private void initPackageList() {
        for (String s : EPPConfig.INSTANCE.tapeWhitelist) {
            ItemMEPackingTape.registerPackableDevice(new class_2960(s));
        }
    }
}

